#!/bin/bash

# diskettelabel.sh
#
# Usage: diskettelabel.sh <device file> <label file> <log file> <dos letter>
#
# Return Codes:
# 1 - Error reading the label
#
# Author: C. Schuck
#
# Module History
#  00  11/21/2003  P. Provost - Changed to use /sbin/e2label because /sbin is not in the root path  

DEVICEFILE=$1
LABELFILE=$2
LOGFILE=$3
DOSLETTER=$4

echo "-> diskettelabel.sh" >> $LOGFILE
echo "Getting the label from the diskette at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> diskettelabel.sh"
actzTrace "XMDA   F: diskettelabel.sh: Getting the label from the diskette at $DEVICEFILE for `date`"

# If the diskette is a DOS diskette, retrieve the diskette label using mdir
if mdir $DOSLETTER > $LABELFILE 2>&1; then
    actzTrace "XMDA   F: diskettelabel.sh: Successfully retrieved the diskette label using mdir."
    actzTrace "XMDA   F: diskettelabel.sh: Label File Listing:"
    echo "Successfully retrieved the diskette label using mdir." >> $LOGFILE
    echo "Label File Listing:" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE
    
# Else if the diskette is a Linux diskette, retrieve the diskette label using e2label     
elif /sbin/e2label $DEVICEFILE > $LABELFILE 2>&1; then
    actzTrace "XMDA   F: diskettelabel.sh: Successfully retrieved the diskette label using e2label."
    actzTrace "XMDA   F: diskettelabel.sh: Label File Listing:"
    echo "Successfully retrieved the diskette label using e2label." >> $LOGFILE
    echo "Label File Listing:" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE
    
# Else the script failed to retrieve the label from the diskette         
else
    actzTrace "XMDA   F: diskettelabel.sh: The attempts to retrieve the label from the diskette have failed."
    echo "The attempts to retrieve the label from the diskette have failed." >> $LOGFILE
    exit 1
fi

actzTrace "XMDA   T: <- diskettelabel.sh"

echo "<- diskettelabel.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0

